package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户-终端关联：分页响应
 *
 * @author zxw
 * @date 2020-10-15 10:21
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationTerminalPageRespVo", description = "用户-终端关联：分页响应")
public class MdmUserRelationTerminalPageRespVo extends CrmExtVo {

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("终端类型名称")
    @CrmDict(typeCode = DictConstant.TERMINAL_TYPE, dictCodeField = "terminalType")
    private String terminalTypeName;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String districtCode;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("终端地址")
    private String terminalAddress;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("sypply表id")
    private String supplyId;

    @ApiModelProperty("店招照片")
    private String shopImagePath;
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;

    @CrmDict(typeCode = DictConstant.CHANNEL,dictCodeField = "channel")
    private String channelName;
}
