package com.biz.crm.nebular.rebate.rebatedetail;

import com.biz.crm.nebular.rebate.area.RebateAreaVo;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返利计算参数对象
 * @Author: chenrong
 * @Date: 2021/1/12 15:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利计算参数对象")
public class RebateComputeParam implements Serializable {

  private static final long serialVersionUID = -8548852252283803554L;

  /**
   * 返利政策编码
   */
  private String rebateCode;
  /**
   * 计算批次号
   */
  private String speedNo;
  /**
   * 公式编码
   */
  private String expressionCode;
  /**
   * 客户编码
   */
  private String cusCode;
  /**
   * 返利产品编码
   */
  private String rebateProductCode;
  /**
   * 返利产品层级编码
   */
  private String rebateProductLevelCode;
  /**
   * 是否产品层级
   */
  private Integer productLevelFlag;
  /**
   * 计算时间
   */
  private Date computeTime;
  /**
   * 返利名称
   */
  private String rebateTitle;
  /**
   * 是否测试
   */
  private Integer isTest = 0;

  /**
   * 返利政策的返利范围
   */
  private List<RebateAreaVo> scopeList;

  /**
   * 返利政策所有客户编码（包括组织下的所有客户）
   */
  private List<RebateAreaVo> cusList;

}
