package com.biz.crm.nebular.sfa.achievement.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 绩效报表 返回vo
 *
 * @author yangshan
 * @date 2021-2-26 16:38:25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "绩效报表")
@SaturnEntity(name = "SfaAchievementRuleTableRespVo", description = "绩效报表")
public class SfaAchievementRuleTableRespVo extends CrmExtTenVo {

    /**
     * 对象编码
     */
    @ApiModelProperty("对象编码")
    private String objectCode;

    /**
     * 对象名称
     */
    @ApiModelProperty("对象名称")
    private String objectName;
    /**
     * 对象类型
     */
    @ApiModelProperty("绩效对象类型")
    private String achievementObjectType;
    /**
     * 对象组织编码
     */
    @ApiModelProperty("对象组织编码")
    private String objectOrgCode;
    /**
     * 对象组织名称
     */
    @ApiModelProperty("对象组织名称")
    private String objectOrgName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    private String objectPosCode;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    private String objectPosName;

    /**
     * 绩效时间
     */
    @ApiModelProperty("绩效时间")
    private String achievementDate;

    /**
     * 绩效类型
     */
    @ApiModelProperty("绩效类型")
    private String achievementType;
    /**
     * 绩效类型名称
     */
    @ApiModelProperty("绩效类型名称")
    private String achievementTypeName;

    /**
     * 指标编码
     */
    @ApiModelProperty("指标编码")
    private String indexCode;

    /**
     * 指标名称
     */
    @ApiModelProperty("指标名称")
    private String indexName;

    /**
     * 权重
     */
    @ApiModelProperty("权重")
    private String weight;

    /**
     * 目标数量
     */
    @ApiModelProperty("目标数量")
    private String targetNum;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 实际完成
     */
    @ApiModelProperty("实际完成数量")
    private String accomplishNum;

    /**
     * 指标达成率
     */
    @ApiModelProperty("指标达成率")
    private String accomplishIndexRate;

    /**
     * 实际完成绩效指标率
     */
    @ApiModelProperty("实际完成绩效指标率")
    private String accomplishAchievementIndexRate;

    @ApiModelProperty("绩效开始时间")
    private String beginDate;

    @ApiModelProperty("绩效结束时间")
    private String endDate;
}
