package com.biz.crm.nebular.sfa.audit.req;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 考勤稽查表请求vo
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAuditAttendanceReqVo", description = "考勤稽查表")
public class SfaAuditAttendanceReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("稽查人员")
    private String auditInspector;

    @ApiModelProperty("稽查编码(系统生成)")
    private String auditCode;

    @ApiModelProperty("稽查人员登录账号")
    private String auditAccount;

    @ApiModelProperty("稽查区域编码")
    private List<String> auditAreaCode;

    @ApiModelProperty("稽查区域")
    private String auditArea;

    @ApiModelProperty("稽查时间")
    private String auditDate;

    @ApiModelProperty("终端所属组织")
    private String terminalOrg;

    @ApiModelProperty("人员编码")
    private String personnelCode;

    @ApiModelProperty("人员姓名")
    private String personnelName;

    @ApiModelProperty("稽查地点")
    private String auditAddress;

    @ApiModelProperty("稽查结果(是否在岗)")
    private Boolean auditResult;

    @ApiModelProperty("稽查结果描述")
    private String auditResultDesc;

    @ApiModelProperty("稽查图片")
    private String auditPicture;

}