package com.biz.crm.nebular.sfa.audit.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 登录人请求终端vo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaTPMTerminalReqVo")
public class SfaTPMTerminalReqVo extends CrmExtTenVo {

    @ApiModelProperty("稽查人员")
    private String auditInspector;

    @ApiModelProperty("登录账号")
    private String auditAccount;

    @ApiModelProperty("稽查区域")
    private List<String> auditAreaCode;

    @ApiModelProperty("稽查区域")
    private String auditArea;

    @ApiModelProperty("客户编码")
    private String terminalCode;

    @ApiModelProperty("客户名称")
    private String terminalName;

    @ApiModelProperty("联系人姓名")
    private String contactName;
}
