package com.biz.crm.nebular.sfa.audit.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 窜货稽查表返回vo
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "窜货稽查表")
public class SfaAuditTransregionalRespVo extends CrmExtTenVo {
    @ApiModelProperty("稽查人员")
    private String auditInspector;

    @ApiModelProperty("区域")
    private List<String> auditArea;

    @ApiModelProperty("稽查区域编码")
    private List<String> auditAreaCode;

    @ApiModelProperty("稽查编码")
    private String auditCode;

    @ApiModelProperty("稽查终端")
    private String auditTerminal;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("稽查时间")
    private String auditDate;

    @ApiModelProperty("稽查结果")
    private Boolean auditResult;

    @ApiModelProperty("稽查结果描述")
    private String auditResultDesc;

    @ApiModelProperty("稽查图片")
    private String auditPicture;

}