package com.biz.crm.nebular.sfa.tpmact.actcollect;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.actcollect
 * @date 2021/6/13 20:10
 */
@Data
@ApiModel(value = "SfaTpmActCollectFormVo",description = "活动采集数据动态表单")
@EqualsAndHashCode(callSuper = false)
public class SfaTpmActCollectFormVo implements Serializable {

    public static final String REDIS_KEY = "sfa_tpm_act_collect";

    public static final Long REDIS_EXPIRE_TIME = Long.valueOf(60*60*24);

    @ApiModelProperty("表单名称")
    private String exampleName;

    @ApiModelProperty("表单编码")
    private String exampleCode;

    @ApiModelProperty("示例图片地址")
    private List<String> pictList;

    @ApiModelProperty("离线图片key对象")
    private List<SfaVisitOffLinePhotoVo> offLinePhotoKey;

    @ApiModelProperty("图片")
    private List<AttachmentVo> attachmentList;


    @Data
    @ApiModel("离线图片key-vo")
    public static class SfaVisitOffLinePhotoVo implements Serializable {

        @ApiModelProperty("图片类型")
        private String key;

        @ApiModelProperty("离线图片key")
        private String photoKey;
    }

    public static String buildRedisKey(String actDetailCode){
        DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String now = LocalDate.now().format(yyyyMMdd);
        return REDIS_KEY+ RedisParam.DELIMITER+actDetailCode+RedisParam.DELIMITER+now;
    }

    public static Map<String,List<SfaTpmActCollectFormVo>> buildRedisMap(String actDetailCode,List<SfaTpmActCollectFormVo> formVoList){
        Map<String,List<SfaTpmActCollectFormVo>> map = new HashMap<>();
        map.put(actDetailCode,formVoList);
        return map;
    }
}
