package com.biz.crm.nebular.sfa.tpmact.displaytreaty;

import com.biz.crm.common.param.RedisParam;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.displaytreaty
 * @date 2021/6/15 16:01
 */
@Data
@ApiModel(value = "SfaTpmActTreatyRedisVo", description = "tpm活动-陈列协议缓存对象")
public class SfaTpmActTreatyRedisVo extends GoodsTreatyVo implements Serializable {

    public static final String REDIS_HASH_KEY = "sfa_tpm_act_display_treaty";

    public static final Long REDIS_EXPIRE_TIME = Long.valueOf(60 * 60 * 12);


    /**
     * 每月支付现金
     */
    @ApiModelProperty("每月支付现金")
    private BigDecimal monthPayAmount;

    /**
     * 合计奖励现金
     */
    @ApiModelProperty("合计奖励现金")
    private BigDecimal totalAmount;

    /**
     * 奖励收款人
     */
    @ApiModelProperty("奖励收款人")
    private String payee;

    /**
     * 联系电话
     */
    @ApiModelProperty("联系电话")
    private String contactPhone;

    /**
     * 获取redis-key
     *
     * @param id
     * @return
     */
    public static String getRedisHashKey(String id) {
        return REDIS_HASH_KEY + RedisParam.DELIMITER + id;
    }

    public static Map<String, String> buildMap(String id, String urlPath) {
        Map<String, String> map = new HashMap<>();
        map.put(id, urlPath);
        return map;
    }
}
