package com.biz.crm.nebular.sfa.tpmact.distributionorder;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jboss.logging.Field;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.tpmact.distributionorder
 * @date 2021/6/13 16:12
 */
@Data
@ApiModel(value = "DistributionOrderVo", description = "tpm活动-分销订单")
public class DistributionOrderVo extends CrmExtVo implements Serializable, VisitBaseVo.StepExecuteDataReq {

    public static final String REDIS_HASH_KEY = "sfa_tpm_act_distribution_order";

    public static final Long redis_expire_time = Long.valueOf(60*60*5);

    @ApiModelProperty("主键id")
    private String id;

    @ApiModelProperty("拜访明细id-工作台可不传")
    private String visitPlanInfoId;

    @ApiModelProperty("表单id")
    private String formId;

    @ApiModelProperty("经度-工作台不传")
    private String longitude;

    @ApiModelProperty("维度-工作台不传")
    private String latitude;

    @ApiModelProperty("步骤编码-可不传")
    private String stepCode;

    @ApiModelProperty("活动编码")
    private String actDetailCode;

    @ApiModelProperty("订单编码")
    private String orderCode;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("上级客户编码")
    private String customerCode;

    @ApiModelProperty("上级客户名称")
    private String customerName;

    @ApiModelProperty("联系人")
    private String contacts;

    @ApiModelProperty("联系电话")
    private String telephone;

    @ApiModelProperty("收货地址")
    private String address;

    @ApiModelProperty("期望收货时间")
    private String expectReceive;

    @ApiModelProperty("总金额")
    private BigDecimal totalPrice;

    @ApiModelProperty("数据状态(offline-离线，online-在线)")
    private String lineStatus;

    @ApiModelProperty("本品商品集合")
    private List<DistributionOrderItem> bpProductList;

    @ApiModelProperty("赠品商品集合")
    private List<DistributionOrderItem> zpProductList;

    @ApiModelProperty("活动信息")
    private SfaTpmActRespVo sfaTpmActRespVo;

    @Data
    @ApiModel(value = "DistributionOrderItem", description = "分销订单行项目")
    public static class DistributionOrderItem {

        @ApiModelProperty("产品编码")
        private String productCode;

        @ApiModelProperty("产品名称")
        private String productName;

        @ApiModelProperty("数量")
        private BigDecimal quantity;

        @ApiModelProperty("单价")
        private BigDecimal price;

        @ApiModelProperty("单位")
        private String saleUnit;

        @ApiModelProperty("单位")
        private String saleUnitName;

        @ApiModelProperty("行类型(1-本品,2-赠品)")
        private String itmeType;

        @ApiModelProperty("备注")
        private String remarks;
    }




    public static String getRedisHashKey(String id) {
        return REDIS_HASH_KEY + RedisParam.DELIMITER + id;
    }


    public static Map<String,DistributionOrderVo> buildMap(String id,DistributionOrderVo vo){
        Map<String,DistributionOrderVo> map = new HashMap<>();
        map.put(id,vo);
        return map;
    }

}
