package com.biz.crm.nebular.sfa.tpmact.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
/**
 * tpm活动请求vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaTpmActReqVo", description = "tpm活动")
public class SfaTpmActReqVo extends CrmBaseVo implements Serializable {

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动描述")
    private String actDesc;

    @ApiModelProperty("开始时间-年月日")
    private String beginDate;

    @ApiModelProperty("结束时间-年月日")
    private String endDate;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("必传参数(0-进行中，1-已完成)")
    private String sfaTpmActStatus;


}