package com.biz.crm.nebular.tpm.act.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * 活动明细信息表关键指标;
 *
 * @author huahongqiang
 * @date 2021-04-07 21:01:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmActDetailKeyTargetVo", description = "活动明细信息表关键指标;")
public class TpmActDetailKeyTargetVo extends CrmExtTenVo {

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;


    @ApiModelProperty("关联预算科目(科目编码)")
    private String budgetSubjectsCode;

    @ApiModelProperty("关联预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户编码")
    private String customerName;

    @ApiModelProperty("费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("预估销售额")
    private BigDecimal forecastSalesAmount;

    @ApiModelProperty("预估费率")
    private BigDecimal feeRate;

}
