package com.biz.crm.nebular.tpm.audit.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmThirtyNumberExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.tpm.audit.TpmAuditDetailReplenishmentProductVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 核销申请明细表 请求vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAuditDetailReqVo", description = "核销申请明细表 ")
public class TpmAuditDetailReqVo extends CrmThirtyNumberExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("核销申请明细编码")
    private String auditDetailCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("核销客户信息")
    private List<TpmAuditDetailCustomerReqVo> auditDetailCustomerReqVos;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("费用申请金额")
    private BigDecimal actDetailApplyAmount;

    @ApiModelProperty("支付方式(字典编码)")
    private String payType;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型(字典编码)")
    private String payTypeType;

    @ApiModelProperty("已核销金额")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("本次核销金额")
    private BigDecimal auditApplyAmount;

    @ApiModelProperty("已上账金额")
    private BigDecimal feeUsed;

    @ApiModelProperty("是否完全上账(Y/N)")
    private String isAllFeeUsed;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("不包含的编码集合(弹窗使用)")
    private List<String> notInCodeList;

    @ApiModelProperty("核销资料入参")
    private List<TpmAuditFileRespVo> auditFileRespVos;

    @ApiModelProperty("货补产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String productLevelName;

    @ApiModelProperty("货补产品集合")
    private List<TpmAuditDetailReplenishmentProductVo> replenishmentProductList;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

}