package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动附件信息;返回vo
 *
 * @author lf
 * @date 2021-03-08 18:06:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动明细信息;")
@CrmColumnResolve
@SaturnEntity(name = "TpmLiqueurActRegisterDetailRespVo", description = "酒类活动附件信息;")
public class TpmLiqueurActRegisterDetailRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动明细名称")
    private String actDetailName;


    @ApiModelProperty("负责人")
    private String chargeMan;

    @ApiModelProperty("举办单位")
    private String organizer;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("经销商编码")
    private String customerCode;

    @ApiModelProperty("兑付类型编码")
    private String redeemType;

    @ApiModelProperty("宴席类型编码")
    private String banquetType;

    @ApiModelProperty("区域（组织）编码")
    private String orgCode;

    @ApiModelProperty("业务（职位）编码")
    private String positionCode;

    @ApiModelProperty("红包计划发放目的编码")
    private String redEnvelopePlanPurpose;

    @ApiModelProperty("陈列任务编码")
    private String displayTask;

    @ApiModelProperty("三节团拜对象类型编码")
    private String threeFestivalsType;

    @ApiModelProperty("登记（申请金额）")
    private BigDecimal applyAmount;

    @ApiModelProperty("明细附加信息")
    private String detailAttachCode;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否需要核销")
    private String isAudit;

    @ApiModelProperty("核销截至日期")
    private String allowAuditEndDate;

    @ApiModelProperty("核销截至日期时间")
    private String allowAuditEndDateSecond;

    @ApiModelProperty("核销金额")
    private BigDecimal  auditAmount;

    @ApiModelProperty("开始时间")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束时间")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("关联预算")
    private List<TpmLiqueurActRegisterDetailBudgetRespVo> detailBudgetVos;

    @ApiModelProperty("附加信息集合")
    private List<TpmLiqueurActRegisterDetailAttachRespVo> attachVos;

    @ApiModelProperty("上账核销金额")
    private BigDecimal billAuditAmount;

    @ApiModelProperty("物料核销金额")
    private BigDecimal materialsAmount;

    @ApiModelProperty("本次核销金额")
    private BigDecimal amount;

    @ApiModelProperty("兑付类型名称")
    private String redeemTypeName;

    @ApiModelProperty("宴席类型名称")
    private String banquetTypeName;

    @ApiModelProperty("业务（职位）名称")
    private String positionName;

    @ApiModelProperty("红包计划发放目的名称")
    private String redEnvelopePlanPurposeName;

    @ApiModelProperty("三节团拜对象名称")
    private String threeFestivalsTypeName;

    @ApiModelProperty("陈列任务名称")
    private String displayTaskName;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("经销商名称")
    private String customerName;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("礼品品项编码")
    private String giftType;

    @ApiModelProperty("礼品品项名称")
    private String giftTypeName;

    @ApiModelProperty("礼品数量")
    private String gitNumber;

    @ApiModelProperty("礼品单价")
    private BigDecimal gitPrice;

}
