package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动明细主表;返回vo
 *
 * @author lf
 * @date 2021-03-09 13:57:21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动登记主表;")
@CrmColumnResolve
public class TpmLiqueurActRegisterRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("登记总金额(申请总金额)")
    private BigDecimal totalAmount;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    @ApiModelProperty("审批状态名称")
    private String approveStatusName;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("费用预算的集合数据")
    private List<TpmFeeBudgetControlRespVo> editBudgetVos;

    @ApiModelProperty("活动细明登记集合")
    private List<TpmLiqueurActRegisterDetailRespVo> detailVos;

    @ApiModelProperty("活动类型编码(活动细类)")
    private String fineCode;

    @ApiModelProperty("活动类型(细类)")
    private String fineName;

    @ApiModelProperty("开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    private String endDateSecond;

    @ApiModelProperty("活动类型表单")
    private String costFormCode;

    @ApiModelProperty("核销表单编码")
    private String auditFormCode;


}
