package com.biz.crm.nebular.tpm.sale.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 实际销售数据 返回vo
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "实际销售数据 ")
public class TpmSalesDataRespVo extends CrmExtTenVo {

    @ApiModelProperty("岗位编码")
    private String positionCode;

    @ApiModelProperty("岗位名称")
    private String positionName;

    @ApiModelProperty("订单编号")
    private String orderSn;

    @ApiModelProperty("年份")
    private String rsYear;

    @ApiModelProperty("月份")
    private String rsMonth;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("数量")
    private Integer num;

    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("金额小计")
    private BigDecimal totalAmount;

    @ApiModelProperty("下单日期")
    private String orderDate;

}