package com.biz.crm.gaode.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 高德POI关键字查询返回值
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Data
public class AmapPoiResultVo implements Serializable {

    private static final long serialVersionUID = 3428190357524681924L;

    @ApiModelProperty("结果状态值， 0：请求失败；1：请求成功")
    private String status;

    @ApiModelProperty("返回状态说明， status为0时，info返回错误原因，否则返回“OK”。详情参阅info状态表")
    private String info;

    @ApiModelProperty("搜索方案数目(最大值为1000)")
    private String count;

    @ApiModelProperty("搜索POI信息列表")
    private List<AmapPoiVo> pois;


}
