package com.biz.crm.nebular.dms.npromotion.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 促销规则阶梯控件解析对象
 * @Author: chenrong
 * @Date: 2021/4/23 17:33
 */
@Data
public class LadderParseBo implements Serializable {

  //** 源数字（第一个控制值）  **//
  private BigDecimal sourceValue;

  //** 源数字类型，number‘数量’或者amount‘金额’或price‘特价’或ratio’折扣‘（第二个控件的值）  **//
  private String sourceValueType;

  //** 源数字单位类型（如：saleUnit/baseUnit），只有当源数字类型为‘数量’时才会存在   **//
  private String sourceUnitType;

  //** 目标数字（第3个控件值）  **//
  private BigDecimal targetValue;

  //** 目标数字类型，number‘数量’或者amount‘金额’（第四个控件的值）  **//
  private String targetValueType;

  //** 目标数字单位类型（如：saleUnit/baseUnit），只有当目标数字类型为‘数量’时才会存在  **//
  private String targetUnitType;

  public LadderParseBo(BigDecimal sourceValue, String sourceValueType, String sourceUnitType, BigDecimal targetValue, String targetValueType, String targetUnitType) {
    this.sourceValue = sourceValue;
    this.sourceValueType = sourceValueType;
    this.sourceUnitType = sourceUnitType;
    this.targetValue = targetValue;
    this.targetValueType = targetValueType;
    this.targetUnitType = targetUnitType;
  }
}
