package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池调整请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolAdjustReqVo", description = "费用池调整请求VO")
public class FeePoolAdjustReqVo extends CrmExtTenVo {

    @ApiModelProperty("费用池分组")
    private String poolGroup;

    @ApiModelProperty("费用池类型")
    private String poolType;

    @ApiModelProperty("费用使用类型")
    private String useType;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("货补产品层级，货补费用池使用")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级，货补费用池使用")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品，货补费用池使用")
    private String goodsProductCode;

    @ApiModelProperty("货补商品，货补费用池使用")
    private String goodsProductName;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("操作金额/数量")
    private BigDecimal amount;

//    @ApiModelProperty("配置编码")
//    private String configCode;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;

    @ApiModelProperty("（上账表维度）活动编码")
    private String actCode;

    @ApiModelProperty("（上账表维度）活动名称")
    private String actName;

    @ApiModelProperty("（上账表维度）活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("（上账表维度）活动类型")
    private String actType;

    @ApiModelProperty("（上账表维度）活动细类编码")
    private String fineCode;

    @ApiModelProperty("（上账表维度）活动细类名称")
    private String fineName;

    @ApiModelProperty("（上账表维度）活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("（上账表维度）活动大类名称")
    private String categoriesName;

    @ApiModelProperty("（上账表维度）会计科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("（上账表维度）会计科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("（上账表维度）核销编码")
    private String auditCode;

    @ApiModelProperty("（上账表维度）核销明细编码")
    private String auditDetailCode;
}