package com.biz.crm.nebular.kms.confadmin.base;

import com.google.common.base.Enums;
import lombok.Getter;

/**
 * <p>
 *  日期标记常量
 * </p>
 *
 * @author byran
 * @since 2019/10/17
 */
public class BaseDateFlagConstants {

    /**
     * 时间标记种类
     */
    @Getter
    public enum DateFlagClassify {
        /**
         * 开始时间
         */
        START("START", "开始时间"),
        /**
         * 结束时间
         */
        END("END", "结束时间");

        /**
         * 值
         */
        private String value;
        /**
         * 描述
         */
        private String description;


        DateFlagClassify (String value, String description) {
            this.value = value;
            this.description = description;
        }

        public static BaseDateFlagConstants.DateFlagClassify getIfPresent(String name) {
            return Enums.getIfPresent(BaseDateFlagConstants.DateFlagClassify.class, name).orNull();
        }
    }
}
