package com.biz.crm.nebular.kms.grabrule.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 抓单规则配置表请求vo
 *
 * @author Gavin
 * @date 2021-04-16 17:00:42
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsGrabRuleReqVo", description = "抓单规则配置表")
public class KmsGrabRuleReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 4714373576405286725L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("单据类型Id")
    private String orderTypeId;

    @ApiModelProperty("单据类型编码")
    private String orderType;

    @ApiModelProperty("单据下载方式")
    private Integer orderDownloadWay;

    @ApiModelProperty("原始文件格式")
    private Integer fileClassify;

    @ApiModelProperty("文件下载方式")
    private Integer fileDownloadWay;

    @ApiModelProperty("抓单规则名称")
    private String ruleName;

    @ApiModelProperty("登录账号ID")
    private String accountId;

    @ApiModelProperty("登录账号")
    private String loginAcc;

    @ApiModelProperty("登录账号")
    private String loginPass;

    @ApiModelProperty("作用门店是否选择全部标识(Y/N)")
    private String isAllStore;

    @ApiModelProperty("开始时间(正整数)")
    private Integer startTime;

    @ApiModelProperty("结束时间(正整数)")
    private Integer endTime;

    @ApiModelProperty("时间间隔(正整数)")
    private Integer intervalTime;

    @ApiModelProperty("抓单门店")
    private List<KmsGrabRuleStoreReqVo> ruleStoreList;

    @ApiModelProperty("抓单参数")
    private List<KmsGrabRuleParamReqVo> ruleParamList;
}