package com.biz.crm.nebular.mdm.org.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 组织表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@ApiModel(value = "MdmOrgSearchReqVo", description = "组织查询请求vo")
public class MdmOrgSearchReqVo extends PageVo {

    private static final long serialVersionUID = 1689543352127568791L;
    @ApiModelProperty("组织编码集合，查询这些组织及全部组织下级")
    private List<String> underOrgCodeList;

    @ApiModelProperty("模糊查询组织编码或者名称")
    private String orgCodeOrName;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("对应SAP组织编码")
    private String sapOrgCode;

    @ApiModelProperty("对应SAP组织编码集合")
    private List<String> sapOrgCodeList;
}