package com.biz.crm.nebular.mdm.product.resp;

import com.biz.crm.config.CrmDict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.mdm.product.resp
 * @date 2021/7/15 14:09
 */
@ApiModel("商品的基础信息-SFA tpm活动专用")
@Data
public class MdmProductBaseDataRespVo {

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("系列编码")
    private String productLevelCode;

    @ApiModelProperty("系列名称")
    private String productLevelName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("单位")
    private String saleUnit;

    @ApiModelProperty("单位")
    @CrmDict(typeCode = "product_sale_unit",dictCodeField = "saleUnit")
    private String saleUnitName;

    @ApiModelProperty("商品图片")
    private String primaryPictureUrl;

    @ApiModelProperty("SFA图片")
    private String sfaPicUrl;
}
