package com.biz.crm.nebular.mdm.region;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "行政区域返回")
@CrmColumnResolve
public class MdmRegionRespVo extends CrmExtTenVo {

    @ApiModelProperty("CRM行政区域编码")
    private String regionCode;

    @ApiModelProperty("CRM上级行政区域编码")
    private String parentCode;

    @ApiModelProperty("CRM上级行政区域名称")
    private String parentName;

    @ApiModelProperty("行政区域名称")
    private String regionName;

    @ApiModelProperty("行政区域层级")
    private String regionLevel;

    @ApiModelProperty("区域区域层级名称")
    @CrmDict(typeCode = DictConstant.REGION_LEVEL, dictCodeField = "regionLevel")
    private String regionLevelName;

    @ApiModelProperty("邮编")
    private String email;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("是否有子节点")
    private Boolean hasChild;

    @ApiModelProperty("是否有子节点 1是 0否")
    private Integer hasChildFlag;

    @ApiModelProperty("国家统计局行政区域编码")
    private String govRegionCode;

    @ApiModelProperty("国家统计局上级行政区域编码")
    private String govParentCode;

    @ApiModelProperty("国家统计局URL")
    private String govUrl;

}