package com.biz.crm.nebular.mdm.terminal;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @ClassName: MdmTerminalLoginVo
 * @Author: yangfan
 * @Description: 终端小程序登录时终端信息对象
 * @Date: 2021/8/20 14:37
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@CrmColumnResolve
public class MdmTerminalLoginVo implements Serializable {
  @ApiModelProperty("终端编码")
  private String terminalCode;
  @ApiModelProperty("终端名称")
  private String terminalName;
  @ApiModelProperty("终端类型")
  private String terminalType;
  @ApiModelProperty("终端类型名称")
  @CrmDict(typeCode = DictConstant.TERMINAL_TYPE,dictCodeField = "terminalType")
  private String terminalTypeName;
}
