package com.biz.crm.nebular.sfa.actscheme.resp;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动方案文件;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动方案文件;")
@SaturnEntity(name = "SfaActSchemePictureRespVo", description = "活动方案文件;")
public class SfaActSchemePictureRespVo extends UuidVo {

    @ApiModelProperty(value = "访问前缀")
    private String urlPathPrefix;

    @ApiModelProperty(value = "路径")
    private String urlPath;

    @ApiModelProperty(value = "文件名称")
    private String fileName;

    @ApiModelProperty(value = "对象名")
    private String objectName;

    @ApiModelProperty(value = "文件后缀")
    private String suffix;

    @ApiModelProperty("方案id")
    @SaturnColumn(description = "方案id")
    private String actSchemeId;

}