package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 方案活动兑付;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动兑付;")
@SaturnEntity(name = "SfaAsCashingRespVo", description = "方案活动兑付;")
public class SfaAsCashingRespVo extends CrmExtTenVo {

    private static final long serialVersionUID = -3259839428232220261L;
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String activityName;

    @ApiModelProperty("协议编码")
    @SaturnColumn(description = "协议编码")
    private String treatyCode;

    @ApiModelProperty("终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    @SaturnColumn(description = "终端名称")
    private String terminalName;

    @ApiModelProperty("终端地址")
    private String terminalAddr;

    @ApiModelProperty("终端联系人")
    private String terminalUser;

    @ApiModelProperty("终端电话")
    private String terminalPhone;

    @ApiModelProperty("转账金额")
    @SaturnColumn(description = "转账金额")
    private BigDecimal transferAmount;

    @ApiModelProperty("方案活动兑付产品")
    @SaturnColumn(description = "方案活动兑付产品")
    private List<SfaAsCashingProductRespVo> asCashingProductList;

    @ApiModelProperty("方案活动兑付图片")
    @SaturnColumn(description = "方案活动兑付图片")
    private List<SfaAsCashingPictureRespVo> asCashingPictureList;

    @ApiModelProperty("兑付方式")
    @SaturnColumn(description = "兑付方式")
    private String paymentMethod;


}