package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 方案活动执行图片;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动执行图片;")
@SaturnEntity(name = "SfaAsExecutionPictureRespVo", description = "方案活动执行图片;")
public class SfaAsExecutionPictureRespVo extends CrmExtTenVo {


    @ApiModelProperty("执行id")
    @SaturnColumn(description = "执行id")
    private String executionId;

    @ApiModelProperty("陈列类型")
    @SaturnColumn(description = "陈列类型")
    private String displayType;

    @ApiModelProperty("陈列类型描述")
    private String displayTypeDesc;

    @ApiModelProperty(value = "访问前缀")
    private String urlPathPrefix;

    @ApiModelProperty(value = "路径")
    private String urlPath;

    @ApiModelProperty(value = "文件名称")
    private String fileName;

    @ApiModelProperty(value = "对象名")
    private String objectName;

    @ApiModelProperty(value = "文件后缀")
    private String suffix;
}