package com.biz.crm.nebular.sfa.audit.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 稽查人员区域配置表返回vo
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "稽查人员区域配置表")
public class SfaAuditInspectorsRespVo extends CrmExtTenVo {
    @ApiModelProperty("登录账号")
    private String auditAccount;

    @ApiModelProperty("稽查人员姓名")
    private String auditName;

    @ApiModelProperty("稽查人员职位")
    private String auditPosition;

    @ApiModelProperty("稽查区域编码")
    private List<String> auditAreaCode;

    @ApiModelProperty("稽查区域")
    private List<String> auditArea;

    @ApiModelProperty("生效时间")
    private String effectiveDate;

    @ApiModelProperty("失效时间")
    private String failureDate;

}