package com.biz.crm.nebular.sfa.moblie.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.customer.*;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 审批客户信息返回——Vo
 * @author YuanZiJian
 * @date 2021/1/18 15:27
 * @version: V1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SfaCustomerMsgRespVo", description = "审批客户信息返回")
@Accessors(chain = true)
public class SfaCustomerMsgRespVo extends CrmTreeVo {
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("渠道名称")
    @CrmDict(typeCode = "channel", dictCodeField = "channel")
    private String channelName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户组织")
    private String customerOrgName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("操作类型")
    private String operateType;

    @ApiModelProperty("所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织")
    private String orgName;

    @ApiModelProperty("市级编码")
    private String cityCode;

    @ApiModelProperty("区级编码")
    private String districtCode;

    @ApiModelProperty("省级编码")
    private String provinceCode;

    @ApiModelProperty("注册地址")
    private String registeredAddress;

    @ApiModelProperty("工程名")
    private String projectName;

    @ApiModelProperty("客户联系方式")
    private String customerContact;

    @ApiModelProperty("客户法人代表")
    private String legalRepresentative;

    @ApiModelProperty("对接人列表")
    private List<MdmCustomerDockingReqVo> mdmCustomerDockingVos;

    @ApiModelProperty("联系人列表")
    private List<MdmCustomerContactReqVo> mdmCustomerContactVos;

    @ApiModelProperty("销售区域列表")
    private List<MdmCustomerSaleAreaReqVo> mdmCustomerSaleAreaVos;

    @ApiModelProperty("客户编码集合")
    private List<String> customerCodeList;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodeList;

    private String code;

    @ApiModelProperty("锁定状态：009正常，003冻结")
    private String lockState;

    /**
     * 目前的逻辑是客户只能关联一个角色，所以用一个字段返回客户关联角色编码
     */
    @ApiModelProperty("关联角色编码")
    private String roleCode;

    @ApiModelProperty("用户帐号")
    private String userName;

    private String customerPrimary;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("erp编码")
    private String erpCode;

    @ApiModelProperty("审批状态,枚举ActApproveStatusEnum")
    private String actApproveStatus;

    private List<MdmCustomerTypeVo> mdmCustomerTypeVos;
    private List<MdmCustSaleCompanyVo> mdmCustSaleCompanyVos;

    @ApiModelProperty("离店时间")
    private Date outStore;

    @ApiModelProperty("拜访标签")
    private String label;

    @ApiModelProperty("客户编码")
    private String clientCode;
}
