package com.biz.crm.nebular.sfa.visitstep.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author yangshan
 * @date 2021/3/30 16:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "订单明细报表;")
@SaturnEntity(name = "SfaVisitStepOrderTableRespVo", description = "订单明细报表;")
public class SfaVisitStepOrderTableRespVo{

    @ApiModelProperty("订单id")
    private String id;

    @ApiModelProperty("下单时间")
    private String orderTime;

    @ApiModelProperty("订单状态")
    private String approvalStatus;

    @ApiModelProperty("订单状态")
    private String approvalStatusName;

    @ApiModelProperty("订单编码")
    private String orderCode;

    @ApiModelProperty("订单来源")
    private String orderSource;

    @ApiModelProperty("订单来源名称")
    private String orderSourceName;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;
}
