package com.biz.crm.nebular.tpm.costtypecategories.req;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 活动大类范围表;请求vo
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TmpCostTypeCategoriesRangeReqVo", description = "活动大类范围表;")
public class TpmCostTypeCategoriesRangeReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动大/细类编码(tpm:大类/liqueurTpm:细类)")
    private String categoriesCode;

    @ApiModelProperty("范围类型(1,组织,2,组织类型)")
    private Integer rangeType;

    @ApiModelProperty("对应范围的编码")
    private String rangeCode;

    @ApiModelProperty("对应范围的名称")
    private String rangeName;

    @ApiModelProperty("是否包含(Y,包含,N不包含)")
    private String isContain;

    @ApiModelProperty("是否仅当前组织(Y:当前组织,N:当前组织和下级组织)")
    private String isOnlyCurrent;


}
