package com.biz.crm.nebular.tpm.liqueuract.resp;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 酒类活动附件信息;返回vo
 *
 * @author lf
 * @date 2021-03-08 18:33:23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "酒类活动附件信息;")
public class TpmLiqueurActRegisterDetailAttachRespVo extends CrmExtVo {
    @ApiModelProperty("附加信息编码")
    @SaturnColumn(description = "附加信息编码")
    private String attachCode;

    @ApiModelProperty("活动登记单号")
    private String actRegisterCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动明细名称")
    private String actDetailName;

    @ApiModelProperty("投入类型编码")
    private String categoriesCode;

    @ApiModelProperty("投入类型名称")
    private String categoriesName;

    @ApiModelProperty("所属销售公司(字典编码)")
    private String ownedSalesCompany;

    @ApiModelProperty("所属销售公司(字典名称)")
    private String ownedSalesCompanyName;

    @ApiModelProperty("所属客户(编码)")
    private String ownedCusCodes;

    @ApiModelProperty("所属客户名称")
    private String ownedCusCodesName;

    @ApiModelProperty("支付类型")
    private String payType;

    @ApiModelProperty("支付方式类型")
    private String payTypeType;

    @ApiModelProperty("支付类型名称")
    private String payTypeName;

    @ApiModelProperty("归属客户编码")
    private String attributionCusCode;

    @ApiModelProperty("归属客户名称")
    private String attributionCusName;

    @ApiModelProperty("归属季度")
    private String attributionQuarter;

    @ApiModelProperty("归属月份")
    private String attributionMonth;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品类型")
    private String productType;

    @ApiModelProperty("单位编码")
    private String unit;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("申请数量")
    private Long applyNumber;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("审批数量")
    private Long approvalNumber;

    @ApiModelProperty("审批金额")
    private BigDecimal approvalAmount;

    @ApiModelProperty("支付人")
    private String payMan;

    @ApiModelProperty("开户行")
    private String accountBank;

    @ApiModelProperty("账号")
    private String account;

    @ApiModelProperty("支付方式(集合的json,字典)")
    private List<DictItemVo> payTypes;
}
