package com.biz.crm.nebular.dms.feepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description:费用池条目
 * @Author: zhangyuzhu
 * @Date: 2020/9/16 17:35
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "费用池条目信息的vo")
@SaturnEntity(name = "FeePoolDetailVo", description = "费用池条目信息")
@SaturnDomain(value = "feepooldetail")
public class FeePoolDetailVo extends CrmExtVo {

    @ApiModelProperty(value = "费用池条目编码")
    @SaturnColumn(description = "费用池条目编码")
    private String code;

    @ApiModelProperty(value = "费用池编码")
    @SaturnColumn(description = "费用池编码")
    private String feePoolCode;

    @ApiModelProperty(value = "支付方式")
    @SaturnColumn(description = "支付方式")
    private Integer payType;

    /***/
    @ApiModelProperty(value = "调整类型")
    @SaturnColumn(description = "调整类型")
    private Integer adjustmentType;

    /**
     * 手台调整的时候专用
     */
    @ApiModelProperty(value = "调整金额")
    @SaturnColumn(description = "调整金额")
    private BigDecimal adjustmentAmount;

    @ApiModelProperty(value = "费用余额(上账金额)")
    @SaturnColumn(description = "费用余额(上账金额)")
    private BigDecimal balance;

    @ApiModelProperty(value = " 数量（tpm同步需要,估计是代表可以送多少产品）")
    @SaturnColumn(description = " 数量（tpm同步需要,估计是代表可以送多少产品）")
    private Integer goodsNum;

    @ApiModelProperty(value = " 单位（tpm同步需要）")
    @SaturnColumn(description = "单位（tpm同步需要）")
    private String goodsUnit;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户所属组织编码")
    @SaturnColumn(description = "客户所属组织编码")
    private String cusOrgCode;

    @ApiModelProperty(value = "客户所属组织名称")
    @SaturnColumn(description = "客户所属组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "客户所属渠道编码")
    @SaturnColumn(description = "客户所属渠道编码")
    private String cusChannelCode;

    @ApiModelProperty(value = "客户所属渠道名称")
    @SaturnColumn(description = "客户所属渠道名称")
    private String cusChannelName;

    /***/
    @ApiModelProperty(value = "商品范围")
    @SaturnColumn(description = "商品范围")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<FeePoolDetailGoodsVo> goods;

    /***/
    @ApiModelProperty(value = "商品范围商品名称（用中文半角逗号隔开）")
    @SaturnColumn(description = "商品范围商品名称（用中文半角逗号隔开）")
    private String goodsNameStr;

    /***/
    @ApiModelProperty(value = "来源业务单号（记录日志用）")
    @SaturnColumn(description = "来源业务单号（记录日志用）")
    private String sourbNo;
}
