package com.biz.crm.nebular.dms.salestarget;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:销售月目标
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "销售目标月度信息的vo")
@SaturnEntity(name = "SalesMonthTargetVo", description = "销售目标月度信息")
@SaturnDomain(value = "salesmonthtarget")
public class SalesMonthTargetVo extends CrmExtVo {

    @ApiModelProperty(value = "销售目标id")
    @SaturnColumn(description = "销售目标id")
    private String salesTargetId;

    @ApiModelProperty(value = "一月目标销量")
    @SaturnColumn(description = "一月目标销量")
    private BigDecimal janTargetNum;

    /***/
    @ApiModelProperty(value = "一月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "一月目标销量字符串表现(不带小数点)")
    private String janTargetNumStr;

    @ApiModelProperty(value = "二月目标销量")
    @SaturnColumn(description = "二月目标销量")
    private BigDecimal febTargetNum;

    /***/
    @ApiModelProperty(value = "二月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "二月目标销量字符串表现(不带小数点)")
    private String febTargetNumStr;

    @ApiModelProperty(value = "三月目标销量")
    @SaturnColumn(description = "三月目标销量")
    private BigDecimal marTargetNum;

    /***/
    @ApiModelProperty(value = "三月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "三月目标销量字符串表现(不带小数点)")
    private String marTargetNumStr;

    @ApiModelProperty(value = "四月目标销量")
    @SaturnColumn(description = "四月目标销量")
    private BigDecimal aprTargetNum;

    /***/
    @ApiModelProperty(value = "四月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "四月目标销量字符串表现(不带小数点)")
    private String aprTargetNumStr;

    @ApiModelProperty(value = "五月目标销量")
    @SaturnColumn(description = "五月目标销量")
    private BigDecimal mayTargetNum;

    /***/
    @ApiModelProperty(value = "五月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "五月目标销量字符串表现(不带小数点)")
    private String mayTargetNumStr;

    @ApiModelProperty(value = "六月目标销量")
    @SaturnColumn(description = "六月目标销量")
    private BigDecimal junTargetNum;

    /***/
    @ApiModelProperty(value = "六月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "六月目标销量字符串表现(不带小数点)")
    private String junTargetNumStr;

    @ApiModelProperty(value = "七月目标销量")
    @SaturnColumn(description = "七月目标销量")
    private BigDecimal julTargetNum;

    /***/
    @ApiModelProperty(value = "七月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "七月目标销量字符串表现(不带小数点)")
    private String julTargetNumStr;

    @ApiModelProperty(value = "八月目标销量")
    @SaturnColumn(description = "八月目标销量")
    private BigDecimal augTargetNum;

    /***/
    @ApiModelProperty(value = "八月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "八月目标销量字符串表现(不带小数点)")
    private String augTargetNumStr;

    @ApiModelProperty(value = "九月目标销量")
    @SaturnColumn(description = "九月目标销量")
    private BigDecimal sepTargetNum;

    /***/
    @ApiModelProperty(value = "九月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "九月目标销量字符串表现(不带小数点)")
    private String sepTargetNumStr;

    @ApiModelProperty(value = "十月目标销量")
    @SaturnColumn(description = "十月目标销量")
    private BigDecimal octTargetNum;

    /***/
    @ApiModelProperty(value = "十月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "十月目标销量字符串表现(不带小数点)")
    private String octTargetNumStr;

    @ApiModelProperty(value = "十一月目标销量")
    @SaturnColumn(description = "十一月目标销量")
    private BigDecimal novTargetNum;

    /***/
    @ApiModelProperty(value = "十一月目标销量")
    @SaturnColumn(description = "十一月目标销量字符串表现(不带小数点)")
    private String novTargetNumStr;

    @ApiModelProperty(value = "十二月目标销量")
    @SaturnColumn(description = "十二月目标销量")
    private BigDecimal decTargetNum;

    /***/
    @ApiModelProperty(value = "十二月目标销量字符串表现(不带小数点)")
    @SaturnColumn(description = "十二月目标销量字符串表现(不带小数点)")
    private String decTargetNumStr;
}
