package com.biz.crm.nebular.kms.confadmin.resp;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 抓单接口参数下拉单选、下拉多选选项
 * </p>
 *
 * @author Byran
 * @since 2019-08-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "抓单接口参数下拉单选、下拉多选选项 响应对象")
public class BsGrabInterfaceParamOptionRespVo implements Serializable {

    private static final long serialVersionUID = -7710498057931997984L;
    /**
     * 抓单接口参数主表id
     */
    @ApiModelProperty("抓单接口参数主表id")
    private String fieldId;

    /**
     * 列表选项名称
     */
    @ApiModelProperty("列表选项名称")
    private String optionName;

    /**
     * 列表选项值
     */
    @ApiModelProperty("列表选项值")
    private String optionValue;

    /**
     * 列表选项值开始日期
     */
    @ApiModelProperty("开始日期")
    private String optionStartDate;

    /**
     * 列表选项值结束日期
     */
    @ApiModelProperty("结束日期")
    private String optionEndDate;

    /**
     * 展示顺序
     */
    @ApiModelProperty("展示顺序")
    private Integer sortIndex;

    /**
     * 唯一id
     */
    @ApiModelProperty("唯一id")
    private String optionId;
}
