package com.biz.crm.nebular.kms.confadmin.resp;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.kms.confadmin.resp
 * @ClassName TenantryDirectStoreRespVo
 * @Author Gavin
 * @Date 2021/4/14 下午3:09
 * @Description 直营体系门店RespVo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "直营体系门店RespVo")
public class TenantryDirectStoreRespVo implements Serializable {
    private static final long serialVersionUID = -7621295197368141469L;

    private String id;
    /**
     * 商超编码
     */
    private String storeCode;

    /**
     * 商超名称
     */
    private String storeName;
    /**
     * 门店所属大区id
     */
    private String areaId;
    /**
     * 门店所属大区编码
     */
    private String areaCode;
    /**
     * 门店所属大区名称
     */
    private String areaName;
    /**
     * 门店地址
     */
    private String storeAddress;
    /**
     * 联系电话
     */
    private String phone;
}