package com.biz.crm.nebular.kms.finance.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 稽核模板请求vo
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsAuditTemplateReqVo", description = "稽核模板")
public class KmsAuditTemplateReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 8530669133137532583L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("稽核模版名称")
    private String templateName;

    @ApiModelProperty("稽核单据类型 数据字典：kms_order_type")
    private List<String> orderTypeList;

    @ApiModelProperty("稽核条件 数据字典：kms_audit_condition")
    private List<String> conditionList;

    @ApiModelProperty("稽核单据类型")
    private String orderTypeArray;

    @ApiModelProperty("稽核条件")
    private String conditionArray;

    @ApiModelProperty("商超信息")
    private List<KmsAuditTemplateDirectReqVo> directVos;

    private String errorMsg;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;
}