package com.biz.crm.nebular.kms.orderform.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商超订货单表返回vo
 *
 * @author Gavin
 * @date 2021-05-12 18:17:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超订货单表")
public class KmsOrderFormRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -3046516161470768421L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("抓单生成的订单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据当前状态 枚举：kms_order_status")
    private String orderStatus;

    @ApiModelProperty("单据当前状态信息")
    private String orderStatusMsg;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("订单日期")
    private String orderDate;

    @ApiModelProperty("交货日期")
    private String deliveryDate;

    @ApiModelProperty("经营方式")
    private String runMode;

    @ApiModelProperty("订货单总金额（含税）")
    private String finalOrderAmount;

    @ApiModelProperty("订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    @ApiModelProperty("关联ID(企业门店与商超门店表ID)")
    private String storeRelatedId;

    @ApiModelProperty("送货地址")
    private String deliveryAddress;

    @ApiModelProperty("送货联系人")
    private String deliveryContact;

    @ApiModelProperty("送货联系人电话")
    private String deliveryContactPhone;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("订单审批单号")
    private String orderApprovalNumber;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织类型")
    private String customerOrgType;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("SKU最大单位数量汇总")
    private String maxUnitSum;

    @ApiModelProperty("是否加急订单")
    private String isExpedited;

    @ApiModelProperty("SAP订单号")
    private String sapNumber;

    @ApiModelProperty("登录账号")
    private String userName;

    @ApiModelProperty("所属公司")
    private String ownedCompany;

    @ApiModelProperty("订单行详情")
    private List<KmsOrderGoodsRespVo> goodsVos;

    @ApiModelProperty("订单推送SAP时间计算阈值")
    private Integer timeOfDay;
}