package com.biz.crm.nebular.kms.rawdata.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 验收单原始数据表返回vo
 *
 * @author Gavin
 * @date 2021-05-12 19:21:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "验收单原始数据表")
public class KmsAcceptanceFormDetailDwRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -3171371940215846927L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("直营体系ID")
    private String bsDirectSystemId;

    @ApiModelProperty("关联订货单（kms_order_form_detail_dw：orderNumber）")
    private String relateOrderNumber;

    @ApiModelProperty("关联原始订货单（kms_order_form_detail_dw：kaOrderNumber）")
    private String relateKaOrderNumber;

    @ApiModelProperty("抓单生成的验收单编号")
    private String orderNumber;

    @ApiModelProperty("商超验收单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("验收单当前状态")
    private String orderStatus;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("验收日期")
    private String acceptanceDate;

    @ApiModelProperty("验收类型")
    private String acceptanceType;

    @ApiModelProperty("订货单总金额（含税）")
    private String finalOrderAmount;

    @ApiModelProperty("验收单总金额（含税）")
    private String finalAcceptanceAmount;

    @ApiModelProperty("订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @ApiModelProperty("验收单总金额（不含税）")
    private String finalAcceptanceAmountNot;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("登录账号")
    private String userName;

}