package com.biz.crm.nebular.kms.supermarket.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 企业门店与商超门店关系请求vo
 *
 * @author Gavin
 * @date 2021-04-15 11:31:07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsTenantryDirectStoreReqVo", description = "企业门店与商超门店关系")
public class KmsTenantryDirectStoreReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -6240906311636606856L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("企业门店编码")
    private String terminalCode;

    private List<String> terminalCodes;

    @ApiModelProperty("企业门店名称")
    private String terminalName;

    @ApiModelProperty("商超门店Id")
    private String storeId;

    @ApiModelProperty("商超门店编码")
    private String storeCode;

    @ApiModelProperty("商超门店编码集合")
    private List<String> kaStoreCodes;

    @ApiModelProperty("商超门店名称")
    private String storeName;

    @ApiModelProperty("商超门店名称集合")
    private List<String> kaStoreNames;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @ApiModelProperty("对账匹配阈值（天数）")
    private Integer timeOfDay;

    @ApiModelProperty("商超名称集合")
    private List<String> kaNames;

    @ApiModelProperty("直营体系Id集合")
    private List<String> bsDirectSystemIdList;

}