package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Data
@ApiModel(value = "客户信息下拉框")
public class MdmCustomerMsgSelectRespVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户编码/客户名称")
    private String unionName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("客户企业组织编码")
    private String orgCode;

    @ApiModelProperty("客户企业组织名称")
    private String orgName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("启用禁用状态")
    private String enableStatus;

    @ApiModelProperty("锁定状态：009正常，003冻结")
    private String lockState;

    @ApiModelProperty("组织集合")
    private List<MdmOrgRespVo> orgList;

    /**
     * 规则code查询用
     */
    private String ruleCode;

    /**
     * 层级等级查询用
     */
    private Integer levelNum;

    public String getUnionName() {
        return (customerCode == null ? "" : customerCode) + "/" + (customerName == null ? "" : customerName);
    }
}
