package com.biz.crm.nebular.mdm.user.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 客户用户关联终端请求vo
 *
 * @author Tao.Chen
 * @date 2021-04-21 16:39:24
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerUserRelTerminalReqVo", description = "客户用户关联终端")
public class MdmCustomerUserRelTerminalReqVo {

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("替换成该用户登录名")
    private String targetUserName;

    @ApiModelProperty("终端编码集合")
    private List<String> terminalCodeList;

}