package com.biz.crm.nebular.sfa.achievement.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 绩效规则 请求vo
 *
 * @author yangshan
 * @date 2021-3-1 11:19:50
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaAchievementAccomplishRecordReqVo", description = "绩效规则")
public class SfaAchievementAccomplishRecordReqVo extends CrmExtTenVo {

    /**
     * 创建人账号
     */
    @ApiModelProperty("创建人账号")
    private String username;

    /**
     * 创建人职位编码
     */
    @ApiModelProperty("创建人职位编码")
    private String objectPosCode;

    /**
     * 指标编码
     */
    @ApiModelProperty("指标编码")
    private String indexCode;

    /**
     * 组织编码集合
     */
    @ApiModelProperty("组织编码集合")
    private String createOrgCodeList;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 业务Id
     */
    @ApiModelProperty("业务Id")
    private String relationId;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("创建年月")
    private String createYearMonth;

    /**
     * 拜访类型;拜访类型(临时拜访/计划拜访)
     */
    @ApiModelProperty("拜访类型;拜访类型(temporary:临时拜访/plan:计划拜访)")
    private String visitType;

    /**
     * 拜访大类
     */
    @ApiModelProperty("拜访大类（VISIT:拜访，HELP_VISIT:协访，UNFAMILIAR_VISIT:陌拜）")
    private String visitBigType;
}
