package com.biz.crm.nebular.sfa.achievement.req;

import com.biz.crm.util.CommonConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 指标规则vo
 *
 * @author yangshan
 * @date 2021-2-23 20:08:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaIndexRuleReqVo", description = "指标规则")
public class SfaIndexRuleReqVo{

    /**
     * 指标编码
     */
    @ApiModelProperty("指标编码")
    private String indexCode;

    /**
     * 指标名称
     */
    @ApiModelProperty("指标名称")
    private String indexName;

    /**
     * 权重
     */
    @ApiModelProperty("权重")
    private String weight = "0";

    /**
     * 目标数量
     */
    @ApiModelProperty("目标数量")
    private String targetNum;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unit;
}
