package com.biz.crm.nebular.sfa.audit.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 终端-TPM活动详情返回VO
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端-TPM活动详情返回VO")
public class SfaAuditTpmActInfoRespVo extends CrmExtTenVo implements Serializable {

    @ApiModelProperty("活动编码")
    private String actDetailCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动描述")
    private String actDesc;

    @ApiModelProperty("开始时间-年月日")
    private String beginDate;

    @ApiModelProperty("结束时间-年月日")
    private String endDate;

    @ApiModelProperty("活动总金额")
    private String totalAmount;

    @ApiModelProperty("活动总金额")
    private String actAmount;

    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("本店已使用金额")
    private BigDecimal currentUsedAmount;

    @ApiModelProperty("活动状态")
    private String actStatusName;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("已核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("稽查终端编码")
    private String auditTerminalCode;

    @ApiModelProperty("稽查地点")
    private String auditAddress;

    @ApiModelProperty("稽查时间")
    private String auditDate;

    @ApiModelProperty("稽查结果")
    private Boolean auditResult;

    @ApiModelProperty("稽查结果描述")
    private String auditResultDesc;

    @ApiModelProperty("稽查照片")
    private String auditPicture;
}
