package com.biz.crm.nebular.sfa.helpdefense.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.helpdefense.SfaHelpDefenseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 协防执行;请求vo
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaHelpDefenseReqVo", description = "协防执行;")
public class SfaHelpDefenseReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("协防人员账号")
    private String helpUserName;

    @ApiModelProperty("协防人员姓名")
    private String helpRealName;

    @ApiModelProperty("协防组织编码")
    private String helpOrgCode;

    @ApiModelProperty("协防组织名称")
    private String helpOrgName;

    @ApiModelProperty("协防职位编码")
    private String helpPosCode;

    @ApiModelProperty("协防职位名称")
    private String helpPosName;

    @ApiModelProperty("协防日期")
    private String helpDefenseDate;

    @ApiModelProperty("被协防人员账号")
    private String coverHelpUserName;

    @ApiModelProperty("被协防人员姓名")
    private String coverHelpRealName;

    @ApiModelProperty("被协防组织编码")
    private String coverHelpOrgCode;

    @ApiModelProperty("被协防组织名称")
    private String coverHelpOrgName;

    @ApiModelProperty("被协防职位编码")
    private String coverHelpPosCode;

    @ApiModelProperty("被协防职位名称")
    private String coverHelpPosName;

    @ApiModelProperty("协防开始时间")
    private String startHelpDefenseDate;

    @ApiModelProperty("协防结束时间")
    private String endHelpDefenseDate;

    @ApiModelProperty("协防客户信息列表")
    private List<SfaHelpDefenseDto> sfaHelpDefenseList;

}