package com.biz.crm.nebular.sfa.tpmact.resp;

import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/6/17 19:20
 */
@Data
public class SfaTpmActTableRespVo extends CrmExtTenVo {

    @ApiModelProperty("网店编码")
    private String clientCode;

    @ApiModelProperty("网店名称")
    private String clientName;

    @ApiModelProperty("活动描述")
    private String activityDesc;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("审批状态")
    private String approveStatus;

    @ApiModelProperty("开始时间-年月日")
    private String beginDate;

    @ApiModelProperty("开始时间-时分秒")
    private String beginDateSecond;

    @ApiModelProperty("结束时间-年月日")
    private String endDate;

    @ApiModelProperty("结束时间-时分秒")
    private String endDateSecond;

    @ApiModelProperty("活动要求")
    private String actDemand;

    @ApiModelProperty("表单信息以及图片")
    private List<SfaTpmActCollectVo.CollectForm> collectFormList;

    @Data
    @ApiModel(value = "CollectForm",description = "动态表单-拍照图片")
    public static class CollectForm{

        @ApiModelProperty("示例名称")
        private String exampleName;

        @ApiModelProperty("示例编码")
        private String exampleCode;
//
//        @ApiModelProperty("示例图片地址")
//        private List<String> pictList;

        @ApiModelProperty("图片")
        private List<AttachmentVo> attachmentList;
    }

    @ApiModelProperty("活动执行描述")
    private String actDesc;

    @ApiModelProperty("网点类型 协访网点类型")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    @ApiModelProperty("采集时间")
    private String collectTime;
}
