package com.biz.crm.nebular.sfa.visitstep.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author yangshan
 * @date 2021/7/6 15:24
 */
@Data
@ApiModel(value = "SFA附件")
public class SfaAttachmentRespVo {

    @ApiModelProperty("业务类型")
    private String attachmentBizType;

    @ApiModelProperty("业务类型")
    private String attachmentBizTypeName;

    @ApiModelProperty("业务id")
    private String bizId;

    @ApiModelProperty("objectName")
    private String objectName;

    @ApiModelProperty("相对路径")
    private String urlPath;

    @ApiModelProperty("域名url")
    private String urlPathPrefix;

    @ApiModelProperty("全路径")
    @Getter(AccessLevel.NONE)
    private String url;

    public String getUrl() {
        if(StringUtils.isBlank(this.url)){
            String urlPath = StringUtils.isBlank(this.objectName) ? this.urlPath : this.objectName;
            return this.urlPathPrefix + urlPath;
        }
        return url;
    }

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("扩展名")
    private String suffix;
}
