package com.biz.crm.gaode.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 高德POI返回值
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Data
public class AmapPoiVo implements Serializable {

    private static final long serialVersionUID = -2945244262094382907L;

    @ApiModelProperty("唯一ID")
    private String id;

    @ApiModelProperty("父POI的ID 当前POI如果有父POI，则返回父POI的ID。可能为空")
    private String parent;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("兴趣点类型 顺序为大类、中类、小类 例如：餐饮服务;中餐厅;特色/地方风味餐厅")
    private String type;

    @ApiModelProperty("兴趣点类型编码 例如：050118")
    private String typecode;

    @ApiModelProperty("行业类型")
    private String biz_type;

    @ApiModelProperty("地址 东四环中路189号百盛北门")
    private String address;

    @ApiModelProperty("经纬度 格式：X,Y")
    private String location;

    @ApiModelProperty("离中心点距离 单位：米；仅在周边搜索的时候有值返回")
    private String distance;

    @ApiModelProperty("POI的电话")
    private String tel;

    @ApiModelProperty("邮编 extensions=all时返回")
    private String postcode;

    @ApiModelProperty("POI的网址  extensions=all时返回")
    private String website;

    @ApiModelProperty("POI的电子邮箱  extensions=all时返回")
    private String email;

    @ApiModelProperty("POI所在省份编码  extensions=all时返回")
    private String pcode;

    @ApiModelProperty("POI所在省份名称 若是直辖市的时候，此处直接显示市名，例如北京市")
    private String pname;

    @ApiModelProperty("城市编码 extensions=all时返回")
    private String citycode;

    @ApiModelProperty("城市名 若是直辖市的时候，此处直接显示市名，例如北京市 ")
    private String cityname;

    @ApiModelProperty("区域编码 extensions=all时返回")
    private String adcode;

    @ApiModelProperty("区域名称 区县级别的返回，例如朝阳区")
    private String adname;

    @ApiModelProperty("POI的入口经纬度  extensions=all时返回，也可用作于POI的到达点；")
    private String entr_location;

    @ApiModelProperty("POI的出口经纬度 目前不会返回内容；")
    private String exit_location;

    @ApiModelProperty("POI导航id extensions=all时返回")
    private String navi_poiid;

    @ApiModelProperty("地理格ID extensions=all时返回")
    private String gridcode;

    @ApiModelProperty("别名  extensions=all时返回")
    private String alias;

    @ApiModelProperty("所在商圈  extensions=all时返回")
    private String business_area;

    @ApiModelProperty("停车场类型 仅在停车场类型POI的时候显示该字段 展示停车场类型，包括：地下、地面、路边  extensions=all的时候显示 ")
    private String parking_type;

    @ApiModelProperty("该POI的特色内容 主要出现在美食类POI中，代表特色菜 例如“烤鱼,麻辣香锅,老干妈回锅肉extensions=all时返回")
    private String tag;

    @ApiModelProperty("是否有室内地图标志 1，表示有室内相关数据 0，代表没有室内相关数据 extensions=all时返回")
    private String indoor_map;

    @ApiModelProperty("室内地图相关数据 当indoor_map=0时，字段为空  extensions=all时返回 ")
    private String indoor_data;

    @ApiModelProperty("照片相关信息 extensions=all时返回")
    private List<AmapPoiPhotoVo> photos;

}
