package com.biz.crm.nebular.dms.npromotion.vo;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 促销政策订单明细实体类
 * @author lf
 * @date 2020-12-26 13:34:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "促销政策订单明细实体类")
public class DmsPromotionPolicyOrderDetailVo extends CrmExtTenVo {

  private static final long serialVersionUID = -6797102330511672055L;

  /**
   * 明细状态 locked:已锁定, commit:已提交, unlock:解除锁定, rollback:已回滚
   */
  @ApiModelProperty(value = "明细状态  commit:已提交,  rollback:已回滚")
  private String policyOrderDetailStatus = "commit";

  /**
   * 促销政策id
   */
  @ApiModelProperty(value = "促销政策id")
  private String promotionPolicyId;

  /**
   * 订单id
   */
  @ApiModelProperty(value = "订单id")
  private String orderId;

  /**
   * 订单号
   */
  @ApiModelProperty(value = "订单号")
  private String orderNo;

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;

  /**
   * 政策使用量
   */
  @ApiModelProperty(value = "政策使用量")
  private BigDecimal usedQty;

  /**
   * 政策使用量类型 QTY_TYPE number:数量, amount:金额
   */
  @ApiModelProperty(value = "政策使用量类型 QTY_TYPE number:数量, amount:金额")
  private String usedQtyType;

  /**
   * 政策使用量单位 rmb:元, product_base_unit:基本单位, material_sale_unit:销售单位
   */
  @ApiModelProperty(value = "政策使用量单位 rmb:元, product_base_unit:基本单位, material_sale_unit:销售单位")
  private String usedQtyUnit;

  /**
   * 命中该政策的明细数据
   */
  @ApiModelProperty(value = "命中该政策的明细数据")
  private String hitDetail;

}
